function [X_v, Y_v]=gener_data(n,expe)
% generates a data sample of size n corresponding to experiment 'expe'
%
% Copyright (C) 2008 Sylvain Arlot
%
%   This program is free software: you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation, either version 3 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with this program.  If not, see <http://www.gnu.org/licenses/>
%
%
% INPUT:
% possible values for the string expe:
% 'S1'   : sine function, constant noise level sigma = 1
% 'S2'   : sine function, noise level sigma(x) = x
% 'HSd1' : HeaviSine function, constant noise level sigma = 1
% 'HSd2' : HeaviSine function, noise level sigma(x) = x
%
% OUTPUT:
% X_v is the row vector of size n of the (sorted) X_i
% Y_v is the row vector of size n of the Y_i 


% Generate independent uniform([0,1]) X_i, whatever the experiment
% note that the X_i are sorted
X_v = sort(rand(1,n));

% Generate independent standard Gaussian epsilon_i, whatever the experiment
eps_v = randn(1,n);

% Compute the noise level at each point, depending on the experiment
switch expe
    case {'S1' 'HSd1'}
        sigma_v=ones(1,n);
    case {'S2' 'HSd2'}
        sigma_v=X_v;
    otherwise
        sigma_v=NaN*ones(1,n);
end

% Compute the regression function at each point, depending on the experiment
switch expe
    case {'S1' 'S2'}
        reg_v=sin(pi*X_v);
    case {'HSd1' 'HSd2'}
        reg_v=4*sin(4*pi*X_v)-sign(X_v-0.3)-sign(0.72-X_v);
    otherwise
        reg_v=NaN*ones(1,n);
end

Y_v=reg_v+sigma_v.*eps_v;