% data generation, model collection definition and usage of RPmodsel_hist.m
%
% Copyright (C) 2008 Sylvain Arlot
%
%   This program is free software: you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation, either version 3 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License
%   along with this program.  If not, see <http://www.gnu.org/licenses/>
%

% parameters for the computation of Resampling Penalties

Wlaw='Loo';% weight vector distribution ('Rad', 'Rho', 'Loo', 'Efr' and 'Poi' are defaults)

type='exact'; % Resampling Penalties are computed exactly
% type='MC(20)'; % Resampling Penalties are computed with Monte-Carlo approximation and B=20 resamples

Cov=1;% overpenalization constant (default = 1)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% parameters for generating data
expe='S1';% framework for generating the data (only 'S1' availabe for the moment)
n=200;% number of data points

% generate data
[X_v, Y_v]=gener_data(n,expe);

% define a collection of models
switch expe
    case 'S1'
	nb_model=floor(n/log(n));% number of models
	m_vect=(1:nb_model);% list of models
	Dm_vect=(1:nb_model);% dimension of the models
	collec=cell(1,nb_model);% collection of models
		for i_m=1:nb_model
        		m=m_vect(i_m);
        		collec{i_m}=(0:m)/m;%regular histogram model
		end%for i_m=1:nb_model
	
    otherwise
        collec=cell(1,1);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% model selection algorithm

[final_model,final_param, crit]=RPmodsel_hist(X_v,Y_v,collec,Wlaw,type,Cov);

% final_model contains the list of the boundaries of the selected partition
% final_param contains the list of the estimated values on the pieces of the selected partition
% crit contains the values of the penalized criterion for each model

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Plot the final estimator and the data

X=(0:.0001:1);
Estim_X=zeros(size(X));
dim=size(final_param,2);
for i=1:dim
    Xind=(X >= final_model(i) & X < final_model(i+1));
    Estim_X(Xind)=final_param(i);
end%for i=1:dim

newplot;
plot(X_v,Y_v,'r+',X,Estim_X,'b-');
legend('data','Final estimator');
xlabel('x');
ylabel('y');
title(['Data and Final estimator; Experiment ' expe ', n=' num2str(n) ' data-points']);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% % Plot the model selection criterion 
% plot(m_vect,crit,'k-');

